%This file applies the augmentation scripts to the downsampled patch pairs to expand the dataset. 
% Augmented images get written to the same directory as the input data with
% appended numbers on the file names

%This does not check for boxes on whitespace following augmentation, use
%the code in splitYoloPatches to do that

addpath('../SyntheticDataGeneration/Augmentation/');
close all
clearvars

showImgs = false;

dataSetDir = '/home/jasper/Datasets/AugmentedData';
duplicationFactor = 20; %number of augmented img pairs to generate per img pair

files = dir(strcat(dataSetDir,'/images/train/'));

for idx = 3:size(files,1)
    name = files(idx).name;
    [~,name,~] = fileparts(name);

    if(mod(idx,20) == 0)
        fprintf("Processing source image %d of %d \n",idx,size(files,1));
    end

    if(name(end) ~= 'A')
        continue;
    end

    I1Orig = imread(strcat(files(idx).folder,'/',name,'.jpg'));
    A1Orig = readAnnot(strcat(dataSetDir,'/labels/train/',name,'.txt'));

    name(end) = 'B';
    I2Orig = imread(strcat(files(idx).folder,'/',name,'.jpg'));
    A2Orig = readAnnot(strcat(dataSetDir,'/labels/train/',name,'.txt'));

    for augNum = 1:duplicationFactor

        %Data Augmentation:
        minRot = -45;
        maxRot = 45; %Degrees
        [I1,I2,A1,A2] = rotateAugment(I1Orig,I2Orig,A1Orig,A2Orig,minRot,maxRot); %Rotate images a random amount, 
        % crop back to original size, fill edges with white. Rotation sampled
        % uniformly from min to max in deg
        shiftStdDev = 10; %in pix
        [I1,I2,A1,A2] = alignmentAugment(I1,I2,A1,A2, shiftStdDev); %Shifts just the first image 
        % (causing a small mis-alignment), shift amount sampled from gaussian, crop and white pad
        shiftStdDev = 10; %in pix
        [I1,I2,A1,A2] = shiftAugment(I1,I2,A1,A2, shiftStdDev); %Shifts both images together, shift 
        % amount sampled from gaussian, crop and white pad
        colourStdDev = 10; %<255
        [I1,I2,A1,A2] = colourAugment(I1,I2,A1,A2, colourStdDev); %Recolour both images independently by 
        % shifting the RGB channels a random amount sampled from gaussian
        hueStdDev = 0.03; %<1
        [I1,I2,A1,A2] = colourHAugment(I1,I2,A1,A2, hueStdDev); %Recolour both images independently by 
        % shifting the hue channel a random amount sampled from gaussian
        satStdDev = 0.1; %<1
        [I1,I2,A1,A2] = colourSAugment(I1,I2,A1,A2, satStdDev); %Recolour both images independently by 
        % shifting the saturation channel a random amount sampled from gaussian
        valStdDev = 0.1; %<1
        [I1,I2,A1,A2] = colourVAugment(I1,I2,A1,A2, valStdDev); %Recolour both images independently by 
        % shifting the value channel a random amount sampled from gaussian
        chanceFlip  = 0.5;
        [I1,I2,A1,A2] = mirrorAugment(I1,I2,A1,A2, chanceFlip); %Flip both images left/right or 
        % top/down. Chanceflip is bernoulli, chance of vert flip is independent of horz flip
        scaleStdDev = 0.05;
        [I1,I2,A1,A2] = scaleAugment(I1,I2,A1,A2, scaleStdDev); %Scale both images a random amount, 
        % sampled from a gaussian
        noiseStdDev = 0.00001; %<1
        [I1,I2,A1,A2] = noiseAugment(I1,I2,A1,A2, noiseStdDev); %Add random noise to each pixel independently 
        % sampled from gaussian
        shearStdDev = 0.1;
        [I1,I2,A1,A2] = shearAugment(I1,I2,A1,A2, shearStdDev); %Apply a shear operation to both images, 'a' value from 
        % https://au.mathworks.com/help/images/padding-and-shearing-an-image-simultaneously.html is sampled from guassian
        surfaceMaxHeight = 5;
        showSurf = false;
        warpTogether = false;
        [I1,I2,A1,A2] = localwarpAugment(I1,I2,A1,A2, surfaceMaxHeight,showSurf,warpTogether); %Map the image onto a 3D surface 
        % and reconstruct locally warped 2D image from this. Not sure how to do this yet.
        [I1,I2,A1,A2] = removeOutsideBoxes(I1,I2,A1,A2); %Remove any annotations that fall outside the image bounds or >40% white/black
        badBoxRatio = 5;
        [I1,I2,A1,A2] = removeBadRatioBoxes(I1,I2,A1,A2,badBoxRatio); %Remove any boxes where one dimension is more than ratio times the other
        saveForAnalysis = true;
        [I1,I2,A1,A2,duplicated] = removeDuplicateAnnotations(I1,I2,A1,A2,saveForAnalysis); %Remove any duplicate annotations. Last arg also saves these files to desktop for checking
        
        if(duplicated == 1)
            fprintf("Found duplicate annotations in %s \n",strcat(name(1:end-1),sprintf('_aug%03d',augNum,'A')));
        elseif(duplicated ==2)
            fprintf("Found duplicate annotations in %s \n",strcat(name(1:end-1),sprintf('_aug%03d',augNum,'B')));
        elseif(duplicated ==3)
            fprintf("Found duplicate annotations in %s \n",strcat(name(1:end-1),sprintf('_aug%03d',augNum,' A and B')));
        end

        if(showImgs)
            figure(1);
            imshow(I1);
            figure(2);
            imshow(I2);
        end

        %Save augmented data
        augname = strcat(name(1:end-1),sprintf('_aug%03d',augNum));
        imwrite(I1,strcat(files(idx).folder,'/',augname,'A.jpg'));
        imwrite(I2,strcat(files(idx).folder,'/',augname,'B.jpg'));
        writeAnnot(A1,strcat(dataSetDir,'/labels/train/',augname,'A.txt'));
        writeAnnot(A2,strcat(dataSetDir,'/labels/train/',augname,'B.txt'));
    end

end
disp("Augmentation complete!");
% fprintf("IMPORTANT: The 'splitYoloPatches' script checks for annotations that now fall on whitespace \n " + ...
%     "If you are not running that script next you need to add the checking code from that to the annotation process. \n " + ...
%     "Otherwise there will be boxes on blank space!\n")
